var strutils = require('../../strutils')

function TapReporter(silent, out){
  this.out = out || process.stdout
  this.silent = silent
  this.stoppedOnError = null
  this.id = 1
  this.total = 0
  this.pass = 0
  this.results = []
  this.errors = []
  this.logs = []
}
TapReporter.prototype = {
  report: function(prefix, data){
    this.results.push({
      launcher: prefix,
      result: data
    })
    this.display(prefix, data)
    this.total++
    if (data.passed) this.pass++
  },
  yamlDisplay: function(err, logs){
    var failed = Object.keys(err || {})
      .filter(function(key){
        return key !== 'passed'
      })
      .map(function(key){
        return key + ': >\n' + strutils.indent(String(err[key]))
      })
    if(logs){
        var testLogs = ["Log: >"].concat(logs.map(function(log){return strutils.indent(String(log))}))
    } else {
        var testLogs = []
    }
    return strutils.indent([
      '---',
      strutils.indent(failed.concat(testLogs).join('\n')),
      '...'].join('\n'))
  },
  resultDisplay: function(prefix, result){
    var line = (prefix ? (prefix + ' - ') : '') +
      result.name.trim()
    return (result.passed ? 'ok ' : 'not ok ') +
      (this.id++) + ' ' + line
  },
  summaryDisplay: function(){
    var lines = [
      '1..' + this.total,
      '# tests ' + this.total,
      '# pass  ' + this.pass,
      '# fail  ' + (this.total - this.pass)
    ]
    if (this.pass === this.total){
      lines.push('')
      lines.push('# ok')
    }
    return lines.join('\n')
  },
  display: function(prefix, result){
    if (this.silent) return
    this.out.write(this.resultDisplay(prefix, result) + '\n')
    if (result.error || result.logs && result.logs.length){
      this.out.write(this.yamlDisplay(result.error, result.logs) + '\n')
    }
  },
  displayError: function(err){
    if (this.silent) return
    this.write('1 not ok "' + err.message.trim() + '"\n')
  },
  finish: function(){
    if (this.silent) return
    this.out.write('\n' + this.summaryDisplay() + '\n')
  }
}

module.exports = TapReporter
